# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 5
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR5_strategy.txt
# LLM Suggested Fallback: C

def harmonious_mirage(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"  # Start with cooperation to establish goodwill
    
    # Analyze opponent's code for naive patterns
    always_c = "return 'c'" in opponent_program_code.lower() or "always cooperate" in opponent_program_code.lower()
    always_d = "return 'd'" in opponent_program_code.lower() or "always defect" in opponent_program_code.lower()
    
    if always_c:
        return "D"  # Exploit always-C opponents
    if always_d:
        return "C" if len(my_history) % 2 == 0 else "D"  # Alternate to minimize losses
    
    # Check opponent's cooperation rate
    coop_rate = sum(1 for move in opp_history if move == "C") / len(opp_history)
    
    if len(my_history) < 3:
        return "C"  # Initial phase: cooperate in first 3 rounds
    
    if coop_rate >= 0.7:
        return "C"  # Maintain cooperation if opponent is mostly cooperative
    elif coop_rate <= 0.3:
        return opp_history[-1]  # Tit-for-Tat if opponent defects frequently
    else:
        # Default to Tit-for-Tat for unclear or complex strategies
        return opp_history[-1]